//=============================================================================
//
// Q[ [modeResult.cpp]
// Author : KENSUKE WATANABE
//
//=============================================================================
#include "main.h"
#include <vector>
#include "utility.h"
#include "manager.h"
#include "modeResult.h"
#include "modeTitle.h"
#include "modeGame.h"
#include "inputKeyboard.h"
#include "scene.h"
#include "scene2D.h"
#include "scene3D.h"
#include "sceneModel.h"
#include "sceneField.h"
#include "sceneSkyDome.h"
#include "sceneCylinder.h"
#include "bgCylinder.h"
#include "effect3DPoly.h"
#include "camera.h"
#include "Wwise.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// FilePass̒萔`
// -------- -------- -------- -------- -------- -------- -------- --------
static const char* TEXNAME_BGCYLINDER = "data/TEXTURE/BG/WtoB.png";

//=============================================================================
// 
//=============================================================================
void CModeResult::Init(void)
{
	CManager::GetCamera()->Init();

	// IuWFNg
	Create();

	SetGrad(255, 192, 64);

	// BGMĐ
	CManager::GetWwise()->MainListenerGameObjEvent(EVENTS::BGM_RESULT);
}

//=============================================================================
// 
//=============================================================================
void CModeResult::Create(void)
{
	// wipOf[VV_[
	m_pBgCylinder = nullptr;
	m_pBgCylinder = m_pBgCylinder->Create(D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1000.f, 500.f, 1000.f), TEXNAME_BGCYLINDER, 2);
}

//=============================================================================
// I
//=============================================================================
void CModeResult::Uninit(void)
{
	// V[S
	CScene::ReleaseAll();

	// GtFNgp3D|SS
	CEffect3DPoly::FlashAll();

	// CXi[̍Đ~
	CManager::GetWwise()->StopMainListener();
}

//=============================================================================
// XV
//=============================================================================
void CModeResult::Update(void)
{
	CInputKeyboard keyboard = CManager::GetKeyboard();

	// Of[V
	static unsigned long long gradCnt;
	if (++gradCnt % 5 == 0)GradationCol(1);

	// V_[̃J[XV
	m_pBgCylinder->SetCol(m_gradR, m_gradG, m_gradB, 255);

	// ͂͑R̃p[eBNo
	float randX = ((std::rand() % 720) - 360) * 0.01f;
	float randZ = ((std::rand() % 720) - 360) * 0.01f;
	float rad = atan2(randZ, randX);
	D3DXVECTOR3 pos = D3DXVECTOR3(cos(rad) * 51.f, 0.f, sin(rad) * 51.f);
	static unsigned long long cntFrame;
	if (++cntFrame % m_createEffectFrame == 0)
	{
		CEffect3DPoly::SetEffect3DPoly(pos, D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.1f, 0.f), 1.f,
			m_gradR, m_gradG, m_gradB, 255, 92, TEXNAME_EFFECT_WTOBLINE);
	}

	// ʑJ
	if (keyboard.GetTrigger(DIK_RETURN))
	{
		CManager::SetMode(new CModeTitle);
	}
}

//=============================================================================
// `揈
//=============================================================================
void CModeResult::Draw(void)
{

}

// ---- Of[V(F̒lグ邾)
void CModeResult::GradationCol(int val)
{
	int r = GetGradR();
	int g = GetGradG();
	int b = GetGradB();

	// ---- R
	if (m_bR == true)
	{
		r = min(r + val, 255);
		if (r >= 255) { m_bR = false; }
	}
	else
	{
		r = max(r - val, 0);
		if (r <= 0) { m_bR = true; }
	}

	// ---- G
	if (m_bG == true)
	{
		g = min(g + val, 255);
		if (g >= 255) { m_bG = false; }
	}
	else
	{
		g = max(g - val, 0);
		if (g <= 0) { m_bG = true; }
	}

	// ---- B
	if (m_bB == true)
	{
		b = min(b + val, 255);
		if (b >= 255) { m_bB = false; }
	}
	else
	{
		b = max(b - val, 0);
		if (b <= 0) { m_bB = true; }
	}

	SetGrad(r, g, b);
}